/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange;

import org.jetbrains.annotations.Nullable;

public enum Star {
    EIN("ein", "Ein", 204800000L),
    ZWEI("zwei", "Zwei", 819200000L),
    DREI("drei", "Drei", 3276800000L),
    VIER("vier", "Vier", 13107200000L),
    SPHERE("sphere", "Sphere", 52428800000L),
    OMEGA("omega", "Omega", 209715200000L);

    public static final Star[] VALUES;
    private final String name;
    private final String displayName;
    private final long maxEMC;

    private Star(String name, String displayName, long maxEMC) {
        this.name = name;
        this.displayName = displayName;
        this.maxEMC = maxEMC;
    }

    @Nullable
    public Star getPrev() {
        return this == EIN ? null : VALUES[this.ordinal() - 1];
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getMaxEMC(boolean colossal) {
        return colossal ? this.maxEMC * 4096L : this.maxEMC;
    }

    static {
        VALUES = Star.values();
    }
}

